_base_ = [
    '../_base_/models/retinanet_r50_fpn.py',
    '../_base_/datasets/coco_detection.py',
    '../_base_/schedules/schedule_1x.py', '../_base_/default_runtime.py'
]
pretrained = './checkpoints/swin_small_patch4_window7_224.pth'  # noqa
model = dict(
    backbone=dict(
        type='RePaSwinTransformer',
        init_cfg=dict(type='Pretrained', checkpoint="checkpoints/repaswin_small_acc_81.6.pth"),
        img_size=224, 
        patch_size=4, 
        in_chans=3,
        embed_dim=96, 
        depths=[2, 2, 18, 2], 
        num_heads=[3, 6, 12, 24],
        window_size=7, 
        mlp_ratio=4., 
        qkv_bias=True, 
        qk_scale=None,
        ape=False, 
        patch_norm=True,
        use_checkpoint=False, 
        fused_window_process=False,
        channel_idle=True,
        drop_path_rate=0.1,
        feature_norm="BatchNorm",
        out_indices=(1, 2, 3)),
    neck=dict(in_channels=[192, 384, 768], start_level=0, num_outs=5))

# optimizer
optim_wrapper = dict(optimizer=dict(lr=0.01))
